import { useEffect, useState } from 'react';

export default function Home() {
  const [users, setUsers] = useState([]);
  const [name, setName] = useState('');
  const [email, setEmail] = useState('');
  const [message, setMessage] = useState('');

  const loadUsers = async () => {
    const res = await fetch('/api/users');
    const data = await res.json();
    if (data.success) setUsers(data.data);
    else setMessage('Failed to load users');
  };

  const addUser = async (e) => {
    e.preventDefault();
    setMessage('Saving...');
    const res = await fetch('/api/users', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ name, email }),
    });
    const data = await res.json();
    if (data.success) {
      setName(''); setEmail('');
      setMessage('User added');
      loadUsers();
    } else {
      setMessage('Error: ' + (data.message || ''));
    }
  };

  useEffect(() => { loadUsers(); }, []);

  return (
    <div style={{ textAlign: 'center', marginTop: 50 }}>
      <h1>Next.js + MySQL Demo</h1>
      <p>Demo app that connects to MySQL via an API route.</p>

      <button onClick={loadUsers}>Load Users</button>

      <h2 style={{ marginTop: 20 }}>Add User</h2>
      <form onSubmit={addUser} style={{ display: 'inline-block', textAlign: 'left' }}>
        <div style={{ marginBottom: 8 }}>
          <label>Name</label><br />
          <input value={name} onChange={e => setName(e.target.value)} required />
        </div>
        <div style={{ marginBottom: 8 }}>
          <label>Email</label><br />
          <input value={email} onChange={e => setEmail(e.target.value)} required />
        </div>
        <div style={{ textAlign: 'center' }}>
          <button type="submit">Save</button>
        </div>
      </form>

      {message && <p style={{ marginTop: 12 }}>{message}</p>}

      {users.length > 0 && (
        <table border="1" style={{ margin: '20px auto', borderCollapse: 'collapse' }}>
          <thead><tr><th>ID</th><th>Name</th><th>Email</th></tr></thead>
          <tbody>
            {users.map(u => (
              <tr key={u.id}><td>{u.id}</td><td>{u.name}</td><td>{u.email}</td></tr>
            ))}
          </tbody>
        </table>
      )}
    </div>
  );
}
